//+------------------------------------------------------------------+
//|                                        Octaves-v3 by Xard777.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

/*--------------------------------------------------------------------
 This indicator is based purely on price. Using price it will work out
   the nearest 4/8th level from any selected frame (128,256,512,1024)
   and build up a trading octave (0/8th to 8/8th) from which to trade
  ------------------------------------------------------------------*/
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#property indicator_chart_window
//+------------------------------------------------------------------+
extern bool babylines=false;
extern bool fifty.percent.line=true;
extern bool show.yesterday.close=false;
extern bool tables=true;
extern bool show.comment=true;
extern int table.font.size = 13;
extern int table.x.offset=10;
extern int table.y.offset=-210;
extern int font.size = 9;
extern int octave.jump = 0;//to move down octaves -1,-2,-3 etc... to move up 1,2,3 etc
extern int frame.size = 128;//frames can be 128,256,512,1024
//+------------------------------------------------------------------+
double  x = 2,
        xx = 0,
        xxx = 0,
        xxxx = 0,
        fractal = 0,
        algorithm = 0,
        minus.two.eight = 0,
        minus.one.eight = 0,
        zero.eight = 0,
        one.eight = 0,
        two.eight = 0,
        three.eight = 0,
        four.eight = 0,
        five.eight = 0,
        six.eight = 0,
        seven.eight = 0,
        eight.eight = 0,
        plus.one.eight = 0,
        plus.two.eight = 0,
        one.eighth.v = 0;
                     
int d = 0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
 ObjectsDeleteAll(0,OBJ_HLINE);
 ObjectsDeleteAll(0,OBJ_TEXT);
 ObjectsDeleteAll(0,OBJ_LABEL);  
//----
    return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();    
//+------------------------------------------------------------------+
//Octave Calculation
double price = iMA(Symbol(),0,1,0,MODE_EMA,PRICE_CLOSE,0);
//+------------------------------------------------------------------+   
   if( price <= 250000 && price > 25000 )
   fractal = 100000;
   else
     if( price <= 25000 && price > 2500 )
     fractal = 10000;
     else
       if( price <= 2500 && price > 250 )
       fractal = 1000;
       else
         if( price <= 250 && price > 25 )
         fractal = 100;
         else
           if( price <= 25 && price > 12.5 )
           fractal = 12.5;
           else
             if( price <= 12.5 && price > 6.25)
             fractal = 12.5;
             else
               if( price <= 6.25 && price > 3.125 )
               fractal = 6.25;
               else
                 if( price <= 3.125 && price > 1.5625 )
                 fractal = 3.125;
                 else
                   if( price <= 1.5625 && price > 0.390625 )
                   fractal = 1.5625;
                   else
                     if( price <= 0.390625 && price > 0)
                     fractal = 0.1953125;
//--------------------------------------------------------------------                      
   algorithm = (MathFloor(price/(fractal/frame.size))*(fractal/frame.size));
   xx = (algorithm - (fractal/frame.size));
   xxx = (algorithm + (fractal/frame.size));
   xxxx = ((xxx-xx)/x);
   zero.eight = xx + (octave.jump * xxxx);
   eight.eight = xxx + (octave.jump * xxxx);
   minus.two.eight = zero.eight - ((eight.eight - zero.eight) * 2/8);
   minus.one.eight = zero.eight - ((eight.eight - zero.eight) * 1/8);
   one.eight = zero.eight + ((eight.eight - zero.eight) * 1/8);
   two.eight = zero.eight + ((eight.eight - zero.eight) * 2/8);
   three.eight = zero.eight + ((eight.eight - zero.eight) * 3/8);
   four.eight = zero.eight + ((eight.eight - zero.eight) * 4/8);
   five.eight = zero.eight + ((eight.eight - zero.eight) * 5/8);
   six.eight = zero.eight + ((eight.eight - zero.eight) * 6/8);
   seven.eight = zero.eight + ((eight.eight - zero.eight) * 7/8);
   plus.one.eight = zero.eight + ((eight.eight - zero.eight) * 9/8);
   plus.two.eight = zero.eight + ((eight.eight - zero.eight) * 10/8);
//--------------------------------------------------------------------
//End of Octave Calculation                     
//+------------------------------------------------------------------+
//Draw our Octave Lines
   ObjectDelete("final.zero_Line");
   
   ObjectCreate("minus.two.eight_Line", OBJ_HLINE,0, CurTime(),minus.two.eight); ObjectSet("minus.two.eight_Line",OBJPROP_COLOR,Red);
   ObjectSet("minus.two.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("minus.two.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("minus.one.eight_Line", OBJ_HLINE,0, CurTime(),minus.one.eight); ObjectSet("minus.one.eight_Line",OBJPROP_COLOR,OrangeRed);
   ObjectSet("minus.one.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("minus.one.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("zero.eight_Line", OBJ_HLINE,0, CurTime(),zero.eight); ObjectSet("zero.eight_Line",OBJPROP_COLOR,DodgerBlue);
   ObjectSet("zero.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("zero.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("one.eight_Line", OBJ_HLINE,0, CurTime(),one.eight); ObjectSet("one.eight_Line",OBJPROP_COLOR,Yellow);
   ObjectSet("one.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("one.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("two.eight_Line", OBJ_HLINE,0, CurTime(),two.eight); ObjectSet("two.eight_Line",OBJPROP_COLOR,DeepPink);
   ObjectSet("two.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("two.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("three.eight_Line", OBJ_HLINE,0, CurTime(),three.eight); ObjectSet("three.eight_Line",OBJPROP_COLOR,Lime);
   ObjectSet("three.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("three.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("four.eight_Line", OBJ_HLINE,0, CurTime(),four.eight); ObjectSet("four.eight_Line",OBJPROP_COLOR,DodgerBlue);
   ObjectSet("four.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("four.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("five.eight_Line", OBJ_HLINE,0, CurTime(),five.eight); ObjectSet("five.eight_Line",OBJPROP_COLOR,Lime);
   ObjectSet("five.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("five.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("six.eight_Line", OBJ_HLINE,0, CurTime(),six.eight); ObjectSet("six.eight_Line",OBJPROP_COLOR,DeepPink);
   ObjectSet("six.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("six.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("seven.eight_Line", OBJ_HLINE,0, CurTime(),seven.eight); ObjectSet("seven.eight_Line",OBJPROP_COLOR,Yellow);
   ObjectSet("seven.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("seven.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("eight.eight_Line", OBJ_HLINE,0, CurTime(),eight.eight); ObjectSet("eight.eight_Line",OBJPROP_COLOR,DodgerBlue);
   ObjectSet("eight.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("eight.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("plus.one.eight_Line", OBJ_HLINE,0, CurTime(),plus.one.eight); ObjectSet("plus.one.eight_Line",OBJPROP_COLOR,OrangeRed);
   ObjectSet("plus.one.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("plus.one.eight_Line",OBJPROP_WIDTH,2);
   
   ObjectCreate("plus.two.eight_Line", OBJ_HLINE,0, CurTime(),plus.two.eight); ObjectSet("plus.two.eight_Line",OBJPROP_COLOR,Red);
   ObjectSet("plus.two.eight_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("plus.two.eight_Line",OBJPROP_WIDTH,2);
            
//End of Octave Lines
//+------------------------------------------------------------------+
//Babylines
double b222,b224,b226;
double b112,b114,b116;
double b02,b04,b06;
double b12,b14,b16;
double b22,b24,b26;
double b32,b34,b36;
double b42,b44,b46;
double b52,b54,b56;
double b62,b64,b66;
double b72,b74,b76;
double b82,b84,b86;
double b92,b94,b96;

double x0 = minus.two.eight;
double x1 = minus.one.eight;
double x2 = zero.eight;
double x3 = one.eight;
double x4 = two.eight;
double x5 = three.eight;
double x6 = four.eight;
double x7 = five.eight;
double x8 = six.eight;
double x9 = seven.eight;
double x10 = eight.eight;
double x11 = plus.one.eight;
double x12 = plus.two.eight;

b222 = ((x1-x0)/4)+x0;
b224 = ((x1-x0)/2)+x0;
b226 = ((x1-x0)/4)*3+x0;

b112 = ((x2-x1)/4)+x1;
b114 = ((x2-x1)/2)+x1;
b116 = ((x2-x1)/4)*3+x1;

b02 = ((x3-x2)/4)+x2;
b04 = ((x3-x2)/2)+x2;
b06 = ((x3-x2)/4)*3+x2;

b12 = ((x4-x3)/4)+x3;
b14 = ((x4-x3)/2)+x3;
b16 = ((x4-x3)/4)*3+x3;

b22 = ((x5-x4)/4)+x4;
b24 = ((x5-x4)/2)+x4;
b26 = ((x5-x4)/4)*3+x4;

b32 = ((x6-x5)/4)+x5;
b34 = ((x6-x5)/2)+x5;
b36 = ((x6-x5)/4)*3+x5;

b42 = ((x7-x6)/4)+x6;
b44 = ((x7-x6)/2)+x6;
b46 = ((x7-x6)/4)*3+x6;

b52 = ((x8-x7)/4)+x7;
b54 = ((x8-x7)/2)+x7;
b56 = ((x8-x7)/4)*3+x7;

b62 = ((x9-x8)/4)+x8;
b64 = ((x9-x8)/2)+x8;
b66 = ((x9-x8)/4)*3+x8;

b72 = ((x10-x9)/4)+x9;
b74 = ((x10-x9)/2)+x9;
b76 = ((x10-x9)/4)*3+x9;

b82 = ((x11-x10)/4)+x10;
b84 = ((x11-x10)/2)+x10;
b86 = ((x11-x10)/4)*3+x10;

b92 = ((x12-x11)/4)+x11;
b94 = ((x12-x11)/2)+x11;
b96 = ((x12-x11)/4)*3+x11;
//---------------------------------------------------------
   if (babylines) {
   ObjectCreate("b222_Line", OBJ_HLINE,0, CurTime(),b222); ObjectSet("b222_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b222_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b222_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b226_Line", OBJ_HLINE,0, CurTime(),b226); ObjectSet("b226_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b226_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b226_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b112_Line", OBJ_HLINE,0, CurTime(),b112); ObjectSet("b112_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b112_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b112_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b116_Line", OBJ_HLINE,0, CurTime(),b116); ObjectSet("b116_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b126_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b116_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b02_Line", OBJ_HLINE,0, CurTime(),b02); ObjectSet("b02_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b02_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b02_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b06_Line", OBJ_HLINE,0, CurTime(),b06); ObjectSet("b06_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b06_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b06_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b12_Line", OBJ_HLINE,0, CurTime(),b12); ObjectSet("b12_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b12_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b12_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b16_Line", OBJ_HLINE,0, CurTime(),b16); ObjectSet("b16_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b16_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b16_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b22_Line", OBJ_HLINE,0, CurTime(),b22); ObjectSet("b22_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b22_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b22_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b26_Line", OBJ_HLINE,0, CurTime(),b26); ObjectSet("b26_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b26_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b26_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b32_Line", OBJ_HLINE,0, CurTime(),b32); ObjectSet("b32_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b32_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b32_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b36_Line", OBJ_HLINE,0, CurTime(),b36); ObjectSet("b36_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b36_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b36_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b42_Line", OBJ_HLINE,0, CurTime(),b42); ObjectSet("b42_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b42_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b42_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b46_Line", OBJ_HLINE,0, CurTime(),b46); ObjectSet("b46_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b46_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b46_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b52_Line", OBJ_HLINE,0, CurTime(),b52); ObjectSet("b52_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b52_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b52_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b56_Line", OBJ_HLINE,0, CurTime(),b56); ObjectSet("b56_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b56_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b56_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b62_Line", OBJ_HLINE,0, CurTime(),b62); ObjectSet("b62_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b62_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b62_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b66_Line", OBJ_HLINE,0, CurTime(),b66); ObjectSet("b66_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b66_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b66_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b72_Line", OBJ_HLINE,0, CurTime(),b72); ObjectSet("b72_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b72_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b72_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b76_Line", OBJ_HLINE,0, CurTime(),b76); ObjectSet("b76_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b76_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b76_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b82_Line", OBJ_HLINE,0, CurTime(),b82); ObjectSet("b82_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b82_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b82_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b86_Line", OBJ_HLINE,0, CurTime(),b86); ObjectSet("b86_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b86_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b86_Line",OBJPROP_WIDTH,0);
  
   ObjectCreate("b92_Line", OBJ_HLINE,0, CurTime(),b92); ObjectSet("b92_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b92_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b92_Line",OBJPROP_WIDTH,0);
   
   ObjectCreate("b96_Line", OBJ_HLINE,0, CurTime(),b96); ObjectSet("b96_Line",OBJPROP_COLOR,DarkSlateGray);
   ObjectSet("b96_Line",OBJPROP_STYLE,STYLE_SOLID); ObjectSet("b96_Line",OBJPROP_WIDTH,0);
   }
   //End of Babylines
//+------------------------------------------------------------------+
if (fifty.percent.line) {
   ObjectCreate("b224_Line", OBJ_HLINE,0, CurTime(),b224); ObjectSet("b224_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b224_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b224_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b114_Line", OBJ_HLINE,0, CurTime(),b114); ObjectSet("b114_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b114_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b114_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b04_Line", OBJ_HLINE,0, CurTime(),b04); ObjectSet("b04_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b04_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b04_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b14_Line", OBJ_HLINE,0, CurTime(),b14); ObjectSet("b14_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b14_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b14_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b24_Line", OBJ_HLINE,0, CurTime(),b24); ObjectSet("b24_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b24_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b24_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b34_Line", OBJ_HLINE,0, CurTime(),b34); ObjectSet("b34_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b34_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b34_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b44_Line", OBJ_HLINE,0, CurTime(),b44); ObjectSet("b44_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b44_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b44_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b54_Line", OBJ_HLINE,0, CurTime(),b54); ObjectSet("b54_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b54_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b54_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b64_Line", OBJ_HLINE,0, CurTime(),b64); ObjectSet("b64_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b64_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b64_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b74_Line", OBJ_HLINE,0, CurTime(),b74); ObjectSet("b74_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b74_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b74_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b84_Line", OBJ_HLINE,0, CurTime(),b84); ObjectSet("b84_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b84_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b84_Line",OBJPROP_WIDTH,0);

   ObjectCreate("b94_Line", OBJ_HLINE,0, CurTime(),b94); ObjectSet("b94_Line",OBJPROP_COLOR,SlateGray);
   ObjectSet("b94_Line",OBJPROP_STYLE,STYLE_DASH); ObjectSet("b94_Line",OBJPROP_WIDTH,0);
   }
//End of fifty.percent.line
//+------------------------------------------------------------------+
//Calculating yesterday close
double rates[1][6],yesterday_close;
ArrayCopyRates(rates, Symbol(), PERIOD_D1);

if(DayOfWeek() == 1) {
   if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,1)) == 5)  {
      yesterday_close = rates[1][4];
      } else {
      for(int dz = 5;d>=0;dz--) {
         if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,dz)) == 5) {
            yesterday_close = rates[d][4];
            }    
      }  
   }
} else {
   yesterday_close = rates[1][4];
   }

double yc = yesterday_close;

   if (show.yesterday.close) {    
   ObjectCreate("yc_Line", OBJ_HLINE,0, CurTime(),yc); ObjectSet("yc_Line",OBJPROP_COLOR,Orange);
   ObjectSet("yc_Line",OBJPROP_STYLE,STYLE_DOT); ObjectSet("yc_Line",OBJPROP_WIDTH,0);
   
   }//End of yesterday close
//+------------------------------------------------------------------+
//tables   
    if (tables) {
   drawLabel24("MK24","Frame",12,Silver,5,25,"Arial Bold");
//+------------------------------------------------------------------+   
   drawLabela00("zero.eight",DoubleToStr(zero.eight,Digits),table.font.size,DodgerBlue,5,25,"Arial Bold");
   drawLabelam1("minus.one.eight",DoubleToStr(minus.one.eight,Digits),table.font.size,Yellow,5,25,"Arial Bold");
   drawLabelam2("minus.two.eight",DoubleToStr(minus.two.eight,Digits),table.font.size,HotPink,5,25,"Arial Bold");
   drawLabela1("one.eight",DoubleToStr(one.eight,Digits),table.font.size,Yellow,5,25,"Arial Bold");
   drawLabela2("two.eight",DoubleToStr(two.eight,Digits),table.font.size,HotPink,5,25,"Arial Bold");
   drawLabela3("three.eight",DoubleToStr(three.eight,Digits),table.font.size,Lime,5,25,"Arial Bold");
   drawLabela4("four.eight",DoubleToStr(four.eight,Digits),table.font.size,DodgerBlue,5,25,"Arial Bold");
   drawLabela5("five.eight",DoubleToStr(five.eight,Digits),table.font.size,Lime,5,25,"Arial Bold");
   drawLabela6("six.eight",DoubleToStr(six.eight,Digits),table.font.size,HotPink,5,25,"Arial bold");
   drawLabela7("seven.eight",DoubleToStr(seven.eight,Digits),table.font.size,Yellow,5,25,"Arial Bold");
   drawLabela8("eight.eight",DoubleToStr(eight.eight,Digits),table.font.size,DodgerBlue,5,25,"Arial Bold");
   drawLabela9("plus.one.eight",DoubleToStr(plus.one.eight,Digits),table.font.size,Yellow,5,25,"Arial Bold");
   drawLabela10("plus.two.eight",DoubleToStr(plus.two.eight,Digits),table.font.size,HotPink,5,25,"Arial Bold");
//+------------------------------------------------------------------+   
   drawLabel.fs("fs",DoubleToStr(frame.size,0),table.font.size,White,5,25,"Arial Bold");
//+------------------------------------------------------------------+   
   drawLabel301("MK301","0/8th",font.size,LightGray,5,25,"Arial");
   drawLabel311("MK311","1/8th",font.size,LightGray,5,25,"Arial");
   drawLabel321("MK321","2/8th",font.size,LightGray,5,25,"Arial");
   drawLabel331("MK331","3/8th",font.size,LightGray,5,25,"Arial");
   drawLabel341("MK341","4/8th",font.size,LightGray,5,25,"Arial");
   drawLabel351("MK351","5/8th",font.size,LightGray,5,25,"Arial");
   drawLabel361("MK361","6/8th",font.size,LightGray,5,25,"Arial");
   drawLabel371("MK371","7/8th",font.size,LightGray,5,25,"Arial");
   drawLabel381("MK381","8/8th",font.size,LightGray,5,25,"Arial");
   drawLabel391("MK391","+1/8th",font.size,LightGray,5,25,"Arial");
   drawLabel401("MK401","+2/8th",font.size,LightGray,5,25,"Arial");
   drawLabel411("MK411","-1/8th",font.size,LightGray,5,25,"Arial");
   drawLabel421("MK421","-2/8th",font.size,LightGray,5,25,"Arial");
   } 
ObjectsRedraw();  
//----

// Screen Header
one.eighth.v=((eight.eight-zero.eight)/8);

if (show.comment) {
Comment("                                                                         ::::: Octaves_v3 by Xard777  8/8: ",one.eighth.v*8,"   7/8: ",one.eighth.v*7,"   6/8: ",one.eighth.v*6,"   5/8: ",one.eighth.v*5,
      "   4/8: ",one.eighth.v*4,"   3/8: ",one.eighth.v*3,"   2/8: ",one.eighth.v*2,"   1/8: ",one.eighth.v*1," :::::");
}

   return(0);
  }
//+------------------------------------------------------------------+
//Drawlabels
void drawLabela00(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 326 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabelam1(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 306 + table.y.offset);
        }}        
//+------------------------------------------------------------------+        
void drawLabelam2(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 290 + table.y.offset);
        }}    
//+------------------------------------------------------------------+        
void drawLabela1(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 342 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabela2(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 358 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabela3(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 374 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabela4(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 390 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabela5(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 406 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabela6(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 422 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabela7(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 438 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabela8(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 454 + table.y.offset);
        }}  
//+------------------------------------------------------------------+        
void drawLabela9(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 474 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabela10(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 885 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 490 + table.y.offset);
        }}                                                                                    
//+------------------------------------------------------------------+
void drawLabel301(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 328 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabel311(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 344 + table.y.offset);
        }}  
//+------------------------------------------------------------------+  
void drawLabel321(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 360 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabel331(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 376 + table.y.offset);
        }}                      
//+------------------------------------------------------------------+        
void drawLabel341(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 392 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabel351(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 408 + table.y.offset);
        }} 
//+------------------------------------------------------------------+        
void drawLabel361(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 424 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabel371(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 440 + table.y.offset);
        }}  
//+------------------------------------------------------------------+        
void drawLabel381(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 456 + table.y.offset);
        }}  
//+------------------------------------------------------------------+        
void drawLabel391(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 838 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 476 + table.y.offset);
        }}  
//+------------------------------------------------------------------+        
void drawLabel401(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 838 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 492 + table.y.offset);
        }}   
//+------------------------------------------------------------------+        
void drawLabel411(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 842 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 308 + table.y.offset);
        }}     
//+------------------------------------------------------------------+        
void drawLabel421(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 842 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 292 + table.y.offset);
        }}                                                                               
//+------------------------------------------------------------------+     
void drawLabel24(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 845 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 512 + table.y.offset);
        }}       
//+------------------------------------------------------------------+        
void drawLabel.fs(string id, string text,int fsize, color fcolor,int f,int r,string font,int window = 0)
     { if(ObjectFind(id)==-1)
         {
        ObjectCreate(id, OBJ_LABEL, window, 0, 0);
        ObjectSetText(id,text, fsize, font, fcolor);
        ObjectSet(id, OBJPROP_CORNER, 2);
        ObjectSet(id, OBJPROP_XDISTANCE, 900 + table.x.offset);
        ObjectSet(id, OBJPROP_YDISTANCE, 512 + table.y.offset);
        }} 
//+------------------------------------------------------------------+   
//End 